/*----------ADD Answers----------------*/
const tinymceoptions = {
            selector: 'textarea.tinymce-textarea',
            menubar: false,
            height: 150,
            plugins: 'autoresize charmap image',
            toolbar: 'undo redo | bold italic underline strikethrough | link image media table | align lineheight | numlist bullist indent outdent | removeformat | paste',    
            toolbar_persist: false,
            statusbar: false,
            images_upload_url: '/inc/postAcceptor.php',
            images_upload_base_path: '/',
            automatic_uploads: true,
            hidden_input: false,
            paste_block_drop: false,
            paste_as_text: true,
            setup: function(editor) {
                editor.on('change blur', function(e) {
                    console.log(e.target.id.includes("question"));
                    if(!e.target.id.includes("answer")){
                    var elem = $("#"+ e.target.id).closest('.question').attr('id');
                      var text = editor.getContent();
                      if(text.length > 0){
                        $('#' + elem + ' .collapsible-header span').html(text);
                      } else {
                        $('#' + elem + ' .collapsible-header span').html('Question');
                      }
                    }
                    tinymce.triggerSave();
                });
            },
            file_picker_callback: function(callback, value, meta) {
                const input = document.createElement('input');
                input.setAttribute('type', 'file');
                //event listeners
                input.addEventListener('change', (e) => {
                 const file = e.target.files[0];

                 const reader = new FileReader();
                 reader.addEventListener('load', () => {
                 //handle data processing with a blob
                  const id = 'blobid' + (new Date()).getTime();
                  const blobCache =  tinymce.activeEditor.editorUpload.blobCache;
                  const base64 = reader.result.split(',')[1];
                  const blobInfo = blobCache.create(id, file, base64);
                  blobCache.add(blobInfo);
                     
                 //Add a callback and get the file name
                  cb(blobInfo.blobUri(), { title: file.name });
                     });
                  reader.readAsDataURL(file);
                   });
                  input.click();
                  },     
            };

$(document).on('click', '.add-answer a', function(){
    var questionCount = $(this).data("question");
    var num = $('#question-'+questionCount+' .answer').map(function() {
      return $(this).data('answer');
    }).get();
    console.log(num);
    if(num.length === 0){
      var highest = 0;  
    } else if(num === null || num === ""){
      var highest = 0;
    } else {
      var highest = Math.max.apply(Math, num);
    }
    var answerCount = highest + 1;
    var answerRow = '<div class="answer row col s12" id="question-'+questionCount+'-answer-'+answerCount+'" data-question="1" data-answer="'+answerCount+'"><div class="answer-text col s9"><div class="input-field"><label for="question-'+questionCount+'-answer-'+answerCount+'-text">Answer</label><textarea id="question-'+questionCount+'-answer-'+answerCount+'-text" class="tinymce-textarea" name="question['+questionCount+'][answer]['+answerCount+'][answerText]"></textarea></div></div><div class="answer-iscorrect col s2"><p><label><input name="question['+questionCount+'][iscorrect]" value="'+answerCount+'" type="radio" /><span>Correct?</span></label></p></div><div class="delete-answer col s1"><a class="waves-effect waves-light btn-small" data-question="'+questionCount+'" data-answer="'+answerCount+'">Delete</a></div><input name="question['+questionCount+'][answer]['+answerCount+'][order]" value="'+answerCount+'" type="hidden" /></div>';
    $('#question-'+questionCount+' #answers').append(answerRow);
    
    tinymce.init(tinymceoptions);
});
/*--------ADD Questions----------------*/
$(document).on('click', '.add-question', function(){
    var num = $('#questions .question').map(function() {
            return $(this).data('question');
      }).get();
    if(num.length === 0){
      var highest = 0;  
    } else if(num === null || num === ""){
      var highest = 0;
    } else {
      var highest = Math.max.apply(Math, num);
    }
    var questionCount = highest + 1;
    var questionRow = '<li class="question row col s12" id="question-'+questionCount+'" data-question="'+questionCount+'"><input name="question['+questionCount+'][order]" type="hidden" value="'+questionCount+'" /><div class="collapsible-header blue-grey-text text-lighten-2"><i class="material-icons">contact_support</i><span>Question</span><div class="delete-question col s1"><a class="red-text text-darken-4" data-question="'+questionCount+'"><i class="material-icons">delete</i></a></div></div><div class="collapsible-body row"><div class="question-text col s10"><label for="question-'+questionCount+'-text">Question</label><textarea id="question-'+questionCount+'-text" class="tinymce-textarea" name="question['+questionCount+'][questionText]"></textarea></div><div class="add-answer col s1"><a class="waves-effect waves-light btn-small" data-question="'+questionCount+'">Add</a></div><div id="answers"><div class="answer row col s12" id="question-'+questionCount+'-answer-1" data-question="'+questionCount+'" data-answer="1"><div class="answer-text col s9"><div class="input-field"><label for="question-'+questionCount+'-answer-1-text">Answer</label><textarea id="question-'+questionCount+'-answer-1-text" class="tinymce-textarea" name="question['+questionCount+'][answer][1][answerText]"></textarea></div></div><div class="answer-iscorrect col s2"><p><label><input name="question['+questionCount+'][iscorrect]" type="radio" value="1" checked /><span>Correct?</span></label></p></div><div class="delete-answer col s1"></div><input name="question['+questionCount+'][answer][1][order]" type="hidden" value="1" /></div></div></div></li>';
    $('#questions').append(questionRow);
    $('.collapsible').collapsible();
    
    tinymce.init(tinymceoptions);
});
/*--------DELETE Answer-----------------*/
$(document).on('click', '.delete-answer a', function(){
  var questionCount = $(this).data("question");
  var answerCount = $(this).data("answer");
  var answerId = $('#question-'+questionCount+'-answer-'+answerCount+' input[name="question['+questionCount+'][answer]['+answerCount+'][id]"]').val();
  if(answerId !== null || answerId !== ""){
  var url = "../inc/class-ajax.php";
  var data = { "action": "delete-answer", "answerId": answerId };
    $.post(url, data, function(r){
      if(r){
        $('#question-'+questionCount+'-answer-'+answerCount).remove();
      } else {
        M.toast({html: 'Error'});
      }
    });
  } else {
    $('#question-'+questionCount+'-answer-'+answerCount).remove();
  }
});
/*--------DELETE ALL Question-----------------*/
$(document).on('click', '.delete-all', function(){
  var sessionId = $('#sessionid').val();
  var url = "../inc/class-ajax.php";
  var data = { "action": "delete-allquestions", "sessionId": sessionId };
  $.post(url, data, function(r){
    if(r){
      M.toast({html: 'All Questions Cleared'});
    } else {
      M.toast({html: 'Error'});
    }
  });
  $('.question').not(':first').remove();
  $('.question:first .answer').not(':first').remove();
  $('.question textarea, .question input').val('');
  $('.question .collapsible-header span').html('Question');
});
/*--------DELETE Question-----------------*/
$(document).on('click', '.delete-question a', function(){
  var questionCount = $(this).data("question");
  var questionId = $('#question-'+questionCount+' input[name="question['+questionCount+'][id]"]').val();
  if(questionId !== null || questionId !== ""){
  var url = "../inc/class-ajax.php";
  var data = { "action": "delete-question", "questionId": questionId };
    $.post(url, data, function(r){
      if(r){
        $('#question-'+questionCount+'').remove();
      } else {
        M.toast({html: 'Error'});
      }
    });
  } else {
    $('#question-'+questionCount+'').remove();
  }
});

/*update for tinymce*/

/*-------Question Label Fill-------------*/
$(document).on('change', '.question-text textarea', function(){
  var elem = $(this).closest('.question').attr('id');
  var text = $(this).val();
  if(text.length > 0){
    $('#' + elem + ' .collapsible-header span').html(text);
  } else {
    $('#' + elem + ' .collapsible-header span').html('Question');
  }
});
/*---Gradiate Non-Selected Questions----*/
$(document).on('click', '.collapsible-header', function(){
    $(this).parent('.question').prevAll().find('.collapsible-header').addClass('text-lighten-2');
    $(this).parent('.question').prevAll().find('.collapsible-header').removeClass('text-darken-2');
    $(this).parent('.question').find('.collapsible-header').removeClass('text-lighten-2');
    $(this).parent('.question').find('.collapsible-header').addClass('text-darken-2');
    $(this).parent('.question').nextAll().find('.collapsible-header').addClass('text-lighten-2');
    $(this).parent('.question').nextAll().find('.collapsible-header').removeClass('text-darken-2');
});
/*---SUBMIT-----*/
$('.save-session').click(function(){
  $('#session-form').submit();
});

// ATTENDANCE
$('.attend').on('click', function(e){
  var sess = $(this).attr('data-sessionid');
  var webid = $(this).attr('data-webid');
  var url = "../inc/class-attempts.php";
  var data = { "action": "check-attend", "sessionId": sess, "userId": webid };
  $('#confirm-attendance').attr('data-sessionid', sess);
  $('#confirm-attendance').attr('data-webid', webid);
  console.log('method2');
  $.post(url, data, function(r){
            if(r.AttemptCount > 0 && r.AttendOnly == 0){
              $('#confirm-attendance').addClass('disabled');
              $('.modal').modal('destroy');
              window.location.href = 'https://natcpd.optometry.org.au/session/?s_id='+sess;
            }
            if(r.AttemptCount > 0 && r.AttendOnly == 1){
              $('#confirm-attendance').addClass('disabled');
              $('.modal .modal-content p').html('<strong>Your attendance has been confirmed for this event.</strong>');
            }
            if(r.AttemptCount == 0){
              $('#confirm-attendance').removeClass('disabled');
            }
        }, "JSON");
});
$('#attend-modal .modal-close').on('click', function(e){
  $('#attend-modal .modal-content p').html('Are you attending this session?');
});
function confirm_Attendance(){
  $('#confirm-attendance').addClass('disabled');
  $('.modal .modal-content p').html('<strong>Please Wait ...</strong>');
  var sess = $('#confirm-attendance').attr('data-sessionid');
  var webid = $('#confirm-attendance').attr('data-webid');
  var url = "../inc/class-attempts.php";
  var data = { "action": "session-attend", "sessionId": sess, "userId": webid };
  console.log('method1');
  $.post(url, data, function(r){
          if(r.attempt && r.AttendOnly == 0){
            $('#confirm-attendance').addClass('disabled');
            $('.modal').modal('destroy');
            window.location.href = 'https://natcpd.optometry.org.au/session/?s_id='+sess;
          }
          if(r.attempt && r.AttendOnly == 1){
            $('.modal .modal-content p').html('<strong>Your attendance has now been confirmed for this event.</strong>');
            $('#confirm-attendance').addClass('disabled');
             setTimeout(function(){window.location.href = 'https://natcpd.optometry.org.au/';},5000);  
          }
        }, "JSON");
}


//CPD UPLOAD
$('.cpd-upload').on('click', function(e){
  var sess = $(this).attr('data-sessionid');
  var url = "../inc/class-attempts.php";
  var data = { "action": "validate-cpd", "sessionId": sess };
  $('#confirm-upload').attr('data-sessionid', sess);
  console.log('method2');
  $.post(url, data, function(r){
            if(r.Status === "ERROR"){
              document.getElementById('cpdreturn-content').innerHTML = JSON.stringify(r);
            }
            if(r.Status === "PASS"){
              document.getElementById('cpdreturn-content').innerHTML = JSON.stringify(r.payload.EventName) + '<br>' + JSON.stringify(r.payload.EntryCollection).slice(0,500);
              $('#confirm-upload').removeClass('disabled');
              $('#confirm-upload').attr('data-payload', r.payloadid);
            }
            
        }, "JSON");
});
$('#cpd-upload-modal .modal-close').on('click', function(e){
  $('#cpd-upload-modal .modal-content p').html('Validating MCQ attempts...');
  $('#confirm-upload').addClass('disabled');
});
function confirm_Commit(){
  $('#confirm-upload').addClass('disabled');
  $('#cpd-upload-modal .modal-content p').html('<strong>Please Wait ...</strong>');
  var sess = $('#confirm-upload').attr('data-sessionid');
  var payload = $('#confirm-upload').attr('data-payload');
  var url = "../inc/class-attempts.php";
  var data = { "action": "commit-cpd", "sessionId": sess, "payload": payload };
  console.log('method1');
  $.post(url, data, function(r){
        if(r !== "Invalid Request"){
            $('p#cpdreturn-content').html('<b>CPD for this session has now been uploaded to Membership 360.</b><br>'+JSON.stringify(r));
            $('#confirm-upload').addClass('disabled');
        } else {
            $('p#cpdreturn-content').html('<b>ERROR.</b><br>');
            $('#confirm-upload').addClass('disabled');
        }
        }, "JSON");
}

function prefill_sessionQuestions(sessiondata){
  $('#sessiondate').val(sessiondata.SessionDate);
  $('#sessionstarttime').val(sessiondata.Start_Time);
  $('#sessionendtime').val(sessiondata.End_Time);
  $('#sessionslot').val(sessiondata.Slot);
  var questions = sessiondata.questions;
  if(questions != null  || questions != ""){
  var qh = "";
  var q;
  var fac = "";
  var i = 1;
  //console.log(questions);
  for (let q = 0; q < Object.keys(questions).length; q++){
    var questionCount = questions[i].QuestionNumber;
    var correctAnswer = questions[i].CorrectAnswer;
    var a;
    var ah = "";
    var f = 1;
    for(let a = 0; a < Object.keys(questions[i].answers).length; a++){
      var answer = questions[i].answers[f];
      var answerCount = answer.AnswerNumber;
      if(correctAnswer == answerCount){
        var correct = "checked";
      } else {
        var correct = "";
      }
      if(f == 1){
        ah += '<div class="answer row col s12" id="question-'+questionCount+'-answer-'+answerCount+'" data-question="'+questionCount+'" data-answer="'+answerCount+'">' +
                '<div class="answer-text col s9">' +
                    '<div class="input-field">' +
                        '<label for="question-'+questionCount+'-answer-'+answerCount+'-text">Answer</label>' +
                        '<textarea id="question-'+questionCount+'-answer-'+answerCount+'-text" class="tinymce-textarea" name="question['+questionCount+'][answer]['+answerCount+'][answerText]">'+answer.Answer+'</textarea>' +
                    '</div>' +
                '</div>' +
                '<div class="answer-iscorrect col s2">' +
                    '<p>' +
                      '<label>' +
                        '<input name="question['+questionCount+'][iscorrect]" type="radio" value="'+answerCount+'" '+correct+' />' +
                        '<span>Correct?</span>' +
                      '</label>' +
                    '</p>' +
                '</div>' +
                '<div class="delete-answer col s1"></div>' +
                    '<input name="question['+questionCount+'][answer]['+answerCount+'][order]" type="hidden" value="'+answerCount+'" />' +
                    '<input name="question['+questionCount+'][answer]['+answerCount+'][id]" type="hidden" value="'+answer.AnswerId+'" />' +
                '</div>';
      } else {
        ah += '<div class="answer row col s12" id="question-'+questionCount+'-answer-'+answerCount+'" data-question="'+questionCount+'" data-answer="'+answerCount+'">' +
                '<div class="answer-text col s9">' +
                    '<div class="input-field">' +
                        '<label for="question-'+questionCount+'-answer-'+answerCount+'-text">Answer</label>' +
                        '<textarea id="question-'+questionCount+'-answer-'+answerCount+'-text" class="tinymce-textarea" name="question['+questionCount+'][answer]['+answerCount+'][answerText]">'+answer.Answer+'</textarea>' +
                    '</div>' +
                '</div>' +
                '<div class="answer-iscorrect col s2">' +
                    '<p>' +
                      '<label>' +
                        '<input name="question['+questionCount+'][iscorrect]" type="radio" value="'+answerCount+'" '+correct+' />' +
                        '<span>Correct?</span>' +
                      '</label>' +
                    '</p>' +
                '</div>' +
                '<div class="delete-answer col s1">' +
                  '<a class="waves-effect waves-light btn-small" data-question="'+questionCount+'" data-answer="'+answerCount+'">Delete</a>' +
                '</div>' +
                    '<input name="question['+questionCount+'][answer]['+answerCount+'][order]" type="hidden" value="'+answerCount+'" />' +
                    '<input name="question['+questionCount+'][answer]['+answerCount+'][id]" type="hidden" value="'+answer.AnswerId+'" />' +
                '</div>';
      }
            f++
    }

    qh += '<li class="question row col s12" id="question-'+questionCount+'" data-question="'+questionCount+'">' +
             '<input name="question['+questionCount+'][order]" type="hidden" value="'+questionCount+'" />' +
             '<input name="question['+questionCount+'][id]" type="hidden" value="'+questions[i].QuestionId+'" />' +
             '<div class="collapsible-header blue-grey-text text-lighten-2">' +
                 '<i class="material-icons">contact_support</i>' +
                 '<span>'+questions[i].Question+'</span>' +
                   '<div class="delete-question col s1">' +
                     '<a class="red-text text-darken-4" data-question="'+questionCount+'">' +
                      '<i class="material-icons">delete</i>' +
                     '</a>' +
                   '</div>' +
              '</div>' +
            '<div class="collapsible-body row">' +
                '<div class="question-text col s10">' +
                 '<label for="question-'+questionCount+'-text">Question</label>' +
                 '<textarea id="question-'+questionCount+'-text" class="tinymce-textarea" name="question['+questionCount+'][questionText]">'+questions[i].Question+'</textarea>' +
                '</div>' +
                '<div class="add-answer col s1">' +
                  '<a class="waves-effect waves-light btn-small" data-question="'+questionCount+'">Add</a>' +
                '</div>' +
                '<div id="answers">' +
                ah +
                '</div>' +
            '</div>' +
          '</li>';
     i++;
  }
  if(qh != ""){
    $('#questions').html(qh);
  }
  }
}

$('#session-form').submit(function(e){
  e.preventDefault();
  /*var tinyeditors = document.getElementsByClassName("tinymce-textarea");
    Array.prototype.forEach.call(tinyeditors, function(tinyeditor) {
        // Do stuff here
        var myContent = tinymce.get(tinyeditor.id).getContent();
        document.getElementById(tinyeditor.id).innerHTML = myContent;
        
        console.log(tinyeditor.id + " - " + myContent);
  });*/
  tinyMCE.triggerSave();
  var url = "../inc/class-ajax.php";
  var data = $(this).serialize();
  $.post(url, data, function(r){
    var q;
    var i = 1;
    r = JSON.parse(r);
    if(r.question != ""){
        M.toast({html: 'Session Details Saved!'});
    }
    for (let q = 1; q < Object.keys(r).length; q++){
      var questionId = r[i].id;
      var questionNumber = r[i].number;
      $('#question-'+questionId+'').prepend('<input name="question['+questionNumber+'][id]" type="hidden" value="'+questionId+'" />');
      var f = 1;
        console.log(Object.keys(r[i].answer));
      for(let a = 1; a < Object.keys(r[i].answer).length; a++){
        var answerId = r[i].answer[f].id;
        var answerNumber = r[i].answer[f].number;
        $('question-'+questionNumber+'-answer-'+answerNumber+'').append('<input name="question['+questionNumber+'][answer]['+answerNumber+'][id]" type="hidden" value="'+answerId+'" />');
        f++;
      }
    }
  });

});

$('.image-upload').submit(function(e){
    e.preventDefault();
    var elem = $(this).attr('id');
    var url = "../inc/class-img-upload.php";
    $.ajax({
           url: url,
           type: "POST",
           data:  new FormData(this),
           contentType: false,
           cache: false,
           processData:false,
           beforeSend : function(){
            //$("#preview").fadeOut();
            $("#err").fadeOut();
           },
           success: function(data){
              if(data=='invalid'){
               // invalid file format.
               $("#err").html("Invalid File !").fadeIn();
              } else {
               // view uploaded file.
               $(elem).closest(".preview").html(data).fadeIn();
               $(".image-upload")[0].reset();
              }},
          error: function(e){
              $("#err").html(e).fadeIn();
          }
      });
});

$(document).ready(function(){
  var isMobile = false; //initiate as false
  // device detection
  if(/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)
      || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0,4))) {
      isMobile = true;
  }
  if(isMobile == false){
    $('.tooltipped').tooltip();
  }
  $('.show-session').click(function(){
      $(this).siblings('.sessions').slideToggle('slow');
  });
$(document).on('click', '.override a', function(){
        var elem = $(this);
          var eventId = $(this).data('event-id');
          var override = $(this).data('override');
          if(eventId !== null || eventId !== ""){
          var url = "../inc/class-ajax.php";
          var data = { "action": "event-override", "eventid": eventId, "override": override };
          $.ajax({
               url: url,
               type: "POST",
               data:  data,
               dataType: "JSON",
               success: function(r){

                  if(r.return===0){
                   elem.removeClass('red');
                   elem.addClass('grey');
                   elem.data('override', 0);
                   alert('Override has been turned off');
                  } else {
                    elem.removeClass('grey');
                    elem.addClass('red');
                   elem.data('override', 1);
                   alert('The Event is now live');
                  }}
          });
          }
  });

  $(document).on('click', '.hide-session a', function(){
          var elem = $(this);
            var sessionId = $(this).data('session-id');
            var hide = $(this).data('hide');
            if(sessionId !== null || sessionId !== ""){
            var url = "../inc/class-ajax.php";
            var data = { "action": "session-hide", "sessionid": sessionId, "hide": hide };
            $.ajax({
                 url: url,
                 type: "POST",
                 data:  data,
                 dataType: "JSON",
                 success: function(r){

                    if(r.return===0){
                     elem.removeClass('red');
                     elem.addClass('grey');
                     elem.data('override', 0);
                     alert('Session is now visible');
                    } else {
                      elem.removeClass('grey');
                      elem.addClass('red');
                     elem.data('override', 1);
                     elem.find('i').html('visibility');
                     alert('Session is now hidden');
                    }}
            });
            }
    });
    $(document).on('click', '.attendance-only a', function(){
            var elem = $(this);
              var sessionId = $(this).data('session-id');
              var attendonly = $(this).data('attendonly');
              if(sessionId !== null || sessionId !== ""){
              var url = "../inc/class-ajax.php";
              var data = { "action": "attendance-only", "sessionid": sessionId, "attendance-only": attendonly };
              $.ajax({
                   url: url,
                   type: "POST",
                   data:  data,
                   dataType: "JSON",
                   success: function(r){
                      if(r.return===0){
                       elem.removeClass('red');
                       elem.addClass('grey');
                       elem.data('attendonly', 0);
                       alert('Attendance Only disabled');
                      } else {
                        elem.removeClass('grey');
                        elem.addClass('red');
                       elem.data('attendonly', 1);
                       alert('Attendance Only Enabled');
                      }}
              });
              }
      });

});
