<?php
 require_once('inc/cpd-head.php');
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <title>elitecpd</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/1.0.0/css/materialize.min.css">
    <link rel="stylesheet" href="/style.css?v=270324.51" type="text/css">
  </head>
  <body>
    <?php
      $sid = $_GET['s_id'];
      $ret_sess = new retrieve_CPD();
      $session = $ret_sess->retrieve_session($sid);
    ?>
    <form method="post" id="assessment-form">
      <input type="hidden" id="session-action" name="action">
      <?php if(isset($login_session['MemberId'])){ ?>
        <input type="hidden" id="user-id" name="user[userId]" value="<?php echo $login_session[$session->ParentId]['DelegateWebID']; ?>">
      <?php } else { ?>
        <input type="hidden" id="user-id" name="user[userId]" value="<?php echo $login_session; ?>">
      <?php } ?>
      <input type="hidden" name="session[sessionId]" value="<?php echo $session->SessionId; ?>">
    <div class="container body-container">
      <div class="bg-header"><h2 class=" blue-grey-text text-darken-2 truncate"><?php echo $session->SessionName; ?></h2></div>
      <div class="dashboard-container row">
        <div class="row col s12">
          <div class="breadcrumbs">
            <ul>
              <li><a href="https://natcpd.optometry.org.au/">Dashboard</a></li>
              <li><?php echo $session->SessionName; ?></li>
            </ul>
          </div>
          <div class="current-attempt">
          </div>
        </div>
        <ul id="questions" class="user-questions">
          <?php
            $attempt = new User();
            if(isset($login_session[$session->ParentId]['DelegateWebID'])){
              $attempts = json_decode(json_encode($attempt->retrieve_Attempts($login_session[$session->ParentId]['DelegateWebID'], $session->SessionId)), FALSE);
            } else {
              $attempts = json_decode(json_encode($attempt->retrieve_Attempts($login_session, $session->SessionId)), FALSE);
            }
            if(!empty($attempts)){
            if($attempts->PassFail == "FAIL" || empty($attempts->PassFail)){
              if($attempts->AttemptCount >= 3 && $attempts->PassFail == "FAIL"){
                  echo '<li class="row col s12"><p>You have attempted assessment three times. You have no remaining attempts available. Please discuss with OVSA office on 03 9652 9100</p></li>';
              } else {
                $cpd = new display_Events();
                echo $cpd->list_sessionQuestions($sid);
              }
            } else {
              echo '<li class="row col s12">You have successfully passed this assessment</li>';
            }
          } else {
              $cpd = new display_Events();
              echo $cpd->list_sessionQuestions($sid);
          }
          ?>
        </ul>
        <?php if($attempts->AttemptCount >= 3 && $attempts->PassFail == "FAIL"  || $attempts->PassFail == "PASS"){ ?>
        <?php } else { ?>
        <div class="row" style="margin-bottom: 0px;">
          <input type="hidden" id="attempt-id" name="AttemptId" value="<?php echo $attempts->AttemptId; ?>">
          <button id="submit" type="submit" class="waves-effect waves-light white-text green btn-flat col s6 center-align"><i class="material-icons">file_upload</i> <strong style="position: relative; top: -5px;">Submit</strong></button>
          <a class="waves-effect waves-light white-text blue lighten-2 btn-flat col s6 center-align save-attempt"><i class="material-icons">save</i> <strong style="position: relative; top: -5px;">Save</strong></a>
        </div>
        <?php } ?>
      </div>
      <!-- Modal Structure -->
      <div id="fail-modal" class="modal">
        <div class="modal-content">
          <h4>Attempt Failed</h4>
          <p>You have not met the required 50% pass rate. Please try again.</p>
        </div>
        <div class="modal-footer">
          <a href="#!" class="modal-close waves-effect waves-green btn-flat"><i class="material-icons">clear</i> Close</a>
        </div>
  </form>
  <script>
  <?php
  if(!empty($attempts)){
      if(isset($attempts->AttemptInfo) && !empty($attempts->AttemptInfo) && $attempts->Completed == "NO"){
        echo 'var prefill = '.$attempts->AttemptInfo.';';
      } else {
        echo 'var prefill = "";';
      }
      if(isset($attempts->AttemptCount) && $attempts->Completed == "YES" || empty($attempts->AttemptCount)){
        echo 'var attemptcount = parseInt('.$attempts->AttemptCount.') + 1;';
      } else {
        echo 'var attemptcount = parseInt('.$attempts->AttemptCount.');';
      }
    } else {
        echo 'var prefill = "";';
        echo 'var attemptcount= "1";';
    }
    ?>
  </script>
  </div>
  <?php include('footer.php'); ?>
