<?php
require_once('class-mailer.php');
require_once('connect.php');
require_once('class-ajax.php');

Class Attempt {

  Public function evaluate($attemptarray){
    $attemptarray = json_decode(json_encode($attemptarray));
    $return = array();
    $core = Core::getInstance();
    $questioncount = 0;
    $correctanswers = 0;
    foreach($attemptarray->question as $question){
      $questionssql = $core->dbc->prepare("SELECT * FROM cpd_questions WHERE QuestionId = :QuestionId");
      $questionssql->execute(array(
          "QuestionId" =>  $question->id
      ));
      $questionarray = $questionssql->fetch(PDO::FETCH_ASSOC);
      if($questionarray['CorrectAnswer'] == $question->answer){
        $return['c'][] = array("n" => $questionarray['QuestionNumber'], "a" => $question->answer);
        $correctanswers++;
      } else {
        $return['w'][] = array("n" => $questionarray['QuestionNumber'], "a" => $question->answer);
      }
      $questioncount++;
    }
    $grade = round($correctanswers/$questioncount*100, 2);
    if($grade >= 50){
      $rec = new Attempt();
      $return['html'] = 'Attempt Successful';
      $rec->record($attemptarray->session->sessionId, $attemptarray->user->userId, $attemptarray, "YES", "PASS");
      $last = new User();
      $lastcheck = $last->retrieve_Attempts($attemptarray->user->userId, $attemptarray->session->sessionId);
      $return['attempt'] = $lastcheck['AttemptCount'];
      $return['attemptid'] = $lastcheck['AttemptId'];
      return json_encode($return);
    } else {
      $rec = new Attempt();
      $return['html'] = 'Attempt Failed';
      $rec->record($attemptarray->session->sessionId, $attemptarray->user->userId, $attemptarray, "YES", "FAIL");
      $last = new User();
      $lastcheck = $last->retrieve_Attempts($attemptarray->user->userId, $attemptarray->session->sessionId);
      $return['attempt'] = $lastcheck['AttemptCount'];
      $return['attemptid'] = $lastcheck['AttemptId'];
      return json_encode($return);
    }
  }

  Public function admin_evaluate($attemptlogarray){
    $attemptarray = json_decode($attemptlogarray);
    $return = array();
    $core = Core::getInstance();
    $questioncount = 0;
    $correctanswers = 0;
    foreach($attemptarray->question as $question){
      $questionssql = $core->dbc->prepare("SELECT * FROM cpd_questions WHERE QuestionId = :QuestionId");
      $questionssql->execute(array(
          "QuestionId" =>  $question->id
      ));
      $questionarray = $questionssql->fetch(PDO::FETCH_ASSOC);
      if($questionarray['CorrectAnswer'] == $question->answer){
        $return['c'][] = array("n" => $questionarray['QuestionNumber'], "a" => $question->answer);
        $correctanswers++;
      } else {
        $return['w'][] = array("n" => $questionarray['QuestionNumber'], "a" => $question->answer);
      }
      $questioncount++;
    }
    $grade = round($correctanswers/$questioncount*100, 2);
    if($grade >= 50){
      $return['html'] = 'Attempt Successful';
      return json_encode($return);
    } else {
      $return['html'] = 'Attempt Failed';
      return json_encode($return);
    }
  }

  Public function record($sessionid, $userid, $attemptarray=array(), $completed = "NO", $PassFail = NULL){
    $attemptarray = json_decode(json_encode($attemptarray));
    $core = Core::getInstance();
    $last = new User();
    $log = new Attempt();
    $lastcheck = $last->retrieve_Attempts($userid, $sessionid);
    if($completed == "YES"){
        if(!empty($attemptarray->AttemptId) && $lastcheck['Completed'] != "NO" || $lastcheck['AttemptCount'] == 0){
          $attemptsql = $core->dbc->prepare("INSERT INTO cpd_attempts ( ParentId, UserId, AttemptInfo, Completed, PassFail ) VALUES ( :ParentId, :UserId, :AttemptInfo, :Completed, :PassFail )");
          $attemptsql->execute(array(
            "ParentId" => $sessionid,
            "UserId" => $userid,
            "AttemptInfo" => json_encode($attemptarray),
            "Completed" => $completed,
            "PassFail" => $PassFail
          ));
          $log->log($sessionid, $userid, $core->dbc->lastInsertId(), $attemptarray, $completed, $PassFail);
      } else {
        $attemptsql = $core->dbc->prepare("UPDATE cpd_attempts SET ParentId=:ParentId, UserId=:UserId, AttemptInfo=:AttemptInfo, Completed=:Completed, PassFail=:PassFail WHERE AttemptId=:AttemptId");
        $attemptsql->execute(array(
          "ParentId" => $sessionid,
          "UserId" => $userid,
          "AttemptInfo" => json_encode($attemptarray),
          "Completed" => $completed,
          "PassFail" => $PassFail,
          "AttemptId" => $attemptarray->AttemptId
        ));
        $log->log($sessionid, $userid, $attemptarray->AttemptId, $attemptarray, $completed, $PassFail);
      }
    } else {
      if(empty($attemptarray->AttemptId)){
        $attemptsql = $core->dbc->prepare("INSERT INTO cpd_attempts ( ParentId, UserId, AttemptInfo, Completed ) VALUES ( :ParentId, :UserId, :AttemptInfo, :Completed )");
        $attemptsql->execute(array(
          "ParentId" => $sessionid,
          "UserId" => $userid,
          "AttemptInfo" => json_encode($attemptarray),
          "Completed" => $completed
        ));
        $log->log($sessionid, $userid, $core->dbc->lastInsertId(), $attemptarray, $completed);
        return($core->dbc->lastInsertId());
      } else {
        $attemptsql = $core->dbc->prepare("UPDATE cpd_attempts SET ParentId=:ParentId, UserId=:UserId, AttemptInfo=:AttemptInfo, Completed=:Completed, PassFail=:PassFail WHERE AttemptId=:AttemptId");
        $attemptsql->execute(array(
          "ParentId" => $sessionid,
          "UserId" => $userid,
          "AttemptInfo" => json_encode($attemptarray),
          "Completed" => $completed,
          "PassFail" => $PassFail,
          "AttemptId" => $attemptarray->AttemptId
        ));
        $log->log($sessionid, $userid, $attemptarray->AttemptId, $attemptarray, $completed, $PassFail);
      }
    }
  }


  Public function log($sessionid, $userid, $attemptid, $attemptarray=array(), $completed = "NO", $PassFail = NULL){
      $core = Core::getInstance();
      if($completed == "YES"){
          $attemptsql = $core->dbc->prepare("INSERT INTO cpd_attempts_log ( ParentId, UserId, AttemptId, AttemptInfo, Completed, PassFail ) VALUES ( :ParentId, :UserId, :AttemptId, :AttemptInfo, :Completed, :PassFail )");
            $attemptsql->execute(array(
              "ParentId" => $sessionid,
              "UserId" => $userid,
              "AttemptInfo" => json_encode($attemptarray),
              "Completed" => $completed,
              "PassFail" => $PassFail,
              "AttemptId" => $attemptid
            ));

      } else {
          $attemptsql = $core->dbc->prepare("INSERT INTO cpd_attempts_log ( ParentId, UserId, AttemptId, AttemptInfo, Completed ) VALUES ( :ParentId, :UserId, :AttemptId, :AttemptInfo, :Completed )");
            $attemptsql->execute(array(
              "ParentId" => $sessionid,
              "UserId" => $userid,
              "AttemptInfo" => json_encode($attemptarray),
              "Completed" => $completed,
              "AttemptId" => $attemptid
            ));
      }
  }

  public function retrieve_logs($sessionid){
      $core = Core::getInstance();
      $attemptsql = $core->dbc->prepare("SELECT * FROM cpd_attempts_log WHERE ParentId=:ParentId");
      $attemptsql->execute(array(
        "ParentId" => $sessionid
      ));
      $attempts = $attemptsql->fetchAll(PDO::FETCH_ASSOC);
      return $attempts;
  }

  public function retrieve_log($logid){
    $core = Core::getInstance();
    $attemptsql = $core->dbc->prepare("SELECT * FROM cpd_attempts_log WHERE Id=:Id LIMIT 1");
    $attemptsql->execute(array(
      "Id" => $logid
    ));
    $attempt = $attemptsql->fetch(PDO::FETCH_ASSOC);
    return $attempt;
  }

  public function validate_cpd($sessionid){
      //DRAFT of cpd upload
      
      //Retrieve passkey token prior to validating/committing 
        $url = "https://wsapi.360membership.com.au/mms2018/EliteCpd/GetToken"; //Placeholder Endpoint
        $data = array(
            "Username" => "EliteCpd.OVSA",
            "Password" => "elite.optometry.25"
        );

        $payload = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload))
        );
      $json = curl_exec($curl);
      if (curl_errno($curl)) {
        print curl_error($curl);
      }
      curl_close($curl);
      $passkey = json_decode($json, FALSE);
      
      //Process results of session
      // $sessionid needed
      // Create array
            $core = Core::getInstance();
            $attemptssql = $core->dbc->prepare("SELECT UserId, AttemptId, ParentId, Completed, PassFail FROM cpd_attempts_log WHERE ParentId=:ParentId");
            $attemptssql->execute(array(
                "ParentId" => $sessionid
            ));
            $attempts = $attemptssql->fetchAll(PDO::FETCH_ASSOC);
            $attempts = json_decode(json_encode($attempts), true);
            $eventsql = $core->dbc->prepare("SELECT ParentId, SessionName, SessionDate, EventName FROM cpd_sessions t1, cpd_events t2 WHERE t1.SessionId=:SessionId AND t1.ParentId=t2.EventId");
            $eventsql->execute(array(
                "SessionId" => $sessionid
            ));
            $event = $eventsql->fetch(PDO::FETCH_ASSOC);
            $eventerr = $eventsql->errorInfo();
            //var_dump($eventerr);
            $cpduploads = array();
            $usersql = $core->dbc->prepare('SELECT * FROM cpd_attendees WHERE DelegateWebId=:DelegateWebId AND MemberId IS NOT NULL');
            foreach($attempts as $attempt){
              if(isset($attempt['UserId']) && !empty($attempt['UserId'])){
                if(!isset($cpduploads[$attempt['UserId']]) && !empty($attempt['UserId'])){
                  $usersql->execute(array(
                    "DelegateWebId" => $attempt['UserId']
                  ));
                  $user = $usersql->fetch(PDO::FETCH_ASSOC);
                  $cpduploads[$attempt['UserId']]['attempts'] = array();
                  $cpduploads[$attempt['UserId']]['UserId'] = $attempt['UserId'];
                  $cpduploads[$attempt['UserId']]['MemberId'] = 'M'.$user['MemberId'];
                  $cpduploads[$attempt['UserId']]['FirstName'] = $user['FirstName'];
                  $cpduploads[$attempt['UserId']]['LastName'] = $user['LastName'];
                  array_push($cpduploads[$attempt['UserId']]['attempts'], $attempt);
                } else {
                  array_push($cpduploads[$attempt['UserId']]['attempts'], $attempt);
                }
              }
            }
            $cpdarray = array();
      
            foreach($cpduploads as $cpdupload){
                
             if($cpdupload['MemberId'] != "M"){
                
              $cpdarray[$cpdupload['UserId']]['MemberId'] = $cpdupload['MemberId'];
              
              $cpdarray[$cpdupload['UserId']]['FirstName'] = $cpdupload['FirstName'];
              $cpdarray[$cpdupload['UserId']]['LastName'] = $cpdupload['LastName'];
              $cpdarray[$cpdupload['UserId']]['attendance'] = true;
                
              //Start Attempts Loop    
              foreach($cpdupload['attempts'] as $row){
                if($cpdarray[$cpdupload['UserId']]['assessment'] != true){
                  $cpdarray[$cpdupload['UserId']]['assessment'] = false;
                    if($row['PassFail'] == "PASS"){
                      $cpdarray[$cpdupload['UserId']]['assessment'] = true;
                    }
                }
              }
              //End Attempts Loop
             } //End Member Id Check
            } //End Foreach loop
      
            //Append Headers
            $list = array();
            // Append results to array
            foreach($cpdarray as $cpd){
              $cpdrow = 
                  array(
                    "MemberId" => $cpd['MemberId'], 
                    "FirstName" => $cpd['FirstName'], 
                    "LastName" => $cpd['LastName'], 
                    "IsAttended" => $cpd['attendance'], 
                    "IsAssessmentPass" => $cpd['assessment'],
                    "ImportReflection" => null
                );
              array_push($list, $cpdrow);
            }
            $date = new DateTimeImmutable(date("Y-m-d\TH:i:s"), new DateTimeZone("Australia/Melbourne"));
            $sessiondate = new DateTimeImmutable(str_replace("/","-",$event["SessionDate"]));
            $body = array(
                "KeyPass" => $passkey,
                "EventId" => $event['ParentId'],
                "SessionId" => $sessionid,
                "EventName" => $event['EventName'],
                "SessionName" => $event['SessionName'],
                "UploadDate" => $date->format("Y-m-d\TH:i:s"),
                "ActivityCompletedDate" => $sessiondate->format("Y-m-d\TH:i:s"),
                "EntryCollection" => $list,
                "Mode" => "VALIDATE"
            );
            
      
        //Post to Validate Results
        $url = "https://wsapi.360membership.com.au/mms2018/EliteCpd/PushData"; //Placeholder Endpoint
        $data = $body;

        $payload = json_encode($data);
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload))
        );
      $json = curl_exec($curl);
      if (curl_errno($curl)) {
        print curl_error($curl);
      }
      curl_close($curl);
      $validate_result = json_decode($json, FALSE);
      if($validate_result->Status == "ERROR"){
        return 'validation error';
      } else {
          $body['Mode'] = "COMMIT";
          $commit_data['Status'] = $validate_result->Status;
          $commit_data['payload'] = $body;
          $payload_sql = $core->dbc->prepare('INSERT INTO `payload_cache` (KeyPass, SessionId, Payload) VALUES (:token, :sessionid, :payload)');
          $payload_sql->execute(array(
                    "token" => $passkey,
                    "sessionid" => $sessionid,
                    "payload" => json_encode($commit_data['payload'])
                ));
          //return json_encode($payload_sql->errorInfo());
          $cacheid = $core->dbc->lastInsertId();
          $commit_data['payloadid']= $cacheid;
          return json_encode($commit_data);
      }
      
  }
    
    public function commit_cpd($sessionid, $payloadid){
        $core=Core::getInstance();
        $payload_sql = $core->dbc->prepare("SELECT * FROM `payload_cache` WHERE Id=:payloadid AND SessionId=:sessionid LIMIT 1");
        $payload_sql->execute(array(
            "payloadid" => $payloadid,
            "sessionid" => $sessionid
        ));
        $payload = $payload_sql->fetch(PDO::FETCH_ASSOC);
        //Post to Validate Results
        $url = "https://wsapi.360membership.com.au/mms2018/EliteCpd/PushData"; //Placeholder Endpoint
        
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $payload['Payload']);

        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($payload['Payload']))
        );
      $json = curl_exec($curl);
      if (curl_errno($curl)) {
        print curl_error($curl);
      }
      curl_close($curl);
      $commit_result = json_decode($json, FALSE);
      $payload_sql = $core->dbc->prepare('DELETE FROM `payload_cache` WHERE `SessionId`=:sessionid');
      $payload_sql->execute(array(
            "sessionid" => $sessionid
        ));    
      return json_encode($commit_result);   
    }
    
    public function record_SessionOverlaps($webid){
    $core = Core::getInstance();
    $attempt_sessionsql = $core->dbc->prepare("SELECT * FROM cpd_attempts WHERE UserId=:webid");
    $attempt_sessionsql->execute(array(
        "webid" => $webid
    ));
    $attempt_sessions = $attempt_sessionsql->fetchAll(PDO::FETCH_ASSOC);
    $session_timesql = $core->dbc->prepare("SELECT ParentId, SessionId, SessionDate, Start_Time, End_Time FROM cpd_sessions WHERE SessionId=:SessionId");
    $barred = array();
    foreach($attempt_sessions as $attempt_session){
        $session_timesql->execute(array(
            "SessionId" => $attempt_session['ParentId']
        ));
        $sessions = $session_timesql->fetchAll(PDO::FETCH_ASSOC);
        foreach($sessions as $session){
            $overlapsql = $core->dbc->prepare('SELECT SessionId FROM `cpd_sessions` WHERE STR_TO_DATE(CONCAT(`SessionDate`," ",`Start_Time`), "%d/%c/%Y %h:%i %p") BETWEEN STR_TO_DATE(CONCAT(:SessionDate1," ",:Start_Time), "%d/%c/%Y %h:%i %p") AND STR_TO_DATE(CONCAT(:SessionDate2," ",:End_Time), "%d/%c/%Y %h:%i %p") AND STR_TO_DATE(CONCAT(`SessionDate`," ",`Start_Time`), "%d/%c/%Y %h:%i %p") <> STR_TO_DATE(CONCAT(:SessionDate3," ",:End_Time2), "%d/%c/%Y %h:%i %p") AND ParentId=:ParentId AND NOT SessionId=:SessionId');
            $overlapsql->execute(array(
                "SessionDate1" => $session['SessionDate'],
                "SessionDate2" => $session['SessionDate'],
                "SessionDate3" => $session['SessionDate'],
                "Start_Time"   => $session['Start_Time'],
                "End_Time"     => $session['End_Time'],
                "End_Time2"     => $session['End_Time'],
                "SessionId"    => $session['SessionId'],
                "ParentId"     => $session['ParentId']
            ));
            $overlaps = $overlapsql->fetchAll(PDO::FETCH_ASSOC);
            foreach($overlaps as $overlap){
                array_push($barred, intval($overlap['SessionId']));
            }
        }
    }
    
    $attendeesql = $core->dbc->prepare('UPDATE cpd_attendees SET BarredSessions = :BarredSessions WHERE DelegateWebID = :DelegateWebID');
    $attendeesql->execute(array(
        "DelegateWebID" => $webid,
        "BarredSessions" => json_encode($barred)
    ));
    
    //print(json_encode($barred));
    //check for all sessions under parent id that have time overlap with attended session and not equal to attended session ID
    //add result to JSON array under new column barred_sessions
}
    
}

$r = $_REQUEST;
$action = $_REQUEST['action'];
$admin = isset($_REQUEST['admin']) ? $_REQUEST['admin'] : 0;
if(isset($r) && !empty($r) && $admin == 0){
  // Changed from sets of "IF" to "SWITCH"
    switch($action){
        case "session-evaluate":
            $att = new Attempt();
            $return = $att->evaluate($r);
            $att->record_SessionOverlaps($r['userId']);
            $mail = new sendMail();
            $mail->sendAttempt(json_encode($r), $return);
            print($return);
        break;
        case "session-save":
            $att = new Attempt();
            $att->record($r['session']['sessionId'], $r['user']['userId'], $r);
            $last = new User();
            $lastcheck = $last->retrieve_Attempts($r['user']['userId'], $r['session']['sessionId']);
            $return['html'] = 'Attempt Saved';
            $return['attempt'] = $lastcheck['AttemptCount'];
            $return['attemptid'] = $lastcheck['AttemptId'];
            $att->record_SessionOverlaps($r['userId']);
            $mail = new sendMail();
            $mail->sendSave(json_encode($r));
            print(json_encode($return));
        break;
        case "session-attend":
            $att = new Attempt();
            $return['attempt'] = $att->record($r['sessionId'], $r['userId'], array());
            $att->record_SessionOverlaps($r['userId']);
            $mail = new sendMail();
            $mail->sendAttendance($r['sessionId'], $r['userId']);
            $return['AttendOnly'] = isAttendanceOnly($r['sessionId']);
            print(json_encode($return));
        break;
        case "check-attend":
            $user = new User();
            $attempts = $user->retrieve_Attempts($r['userId'], $r['sessionId']);
            $attempts['AttendOnly'] = isAttendanceOnly($r['sessionId']);
            print(json_encode($attempts));
        break;
        case "validate-cpd":
            $att = new Attempt();
            $return = $att->validate_cpd($r['sessionId']);
            print($return);
        break;
        case "commit-cpd":
            $att = new Attempt();
            $return = $att->commit_cpd($r['sessionId'],$r['payload']);
            print($return);
        break;
            
    }
//OLD IF STATEMENTS 
  /*if($action == 'session-evaluate'){
    $att = new Attempt();
    $return = $att->evaluate($r);
    $mail = new sendMail();
    $mail->sendAttempt(json_encode($r), $return);
    print($return);
  }
  if($action == 'session-save'){
    $att = new Attempt();
    $att->record($r['session']['sessionId'], $r['user']['userId'], $r);
    $last = new User();
    $lastcheck = $last->retrieve_Attempts($r['user']['userId'], $r['session']['sessionId']);
    $return['html'] = 'Attempt Saved';
    $return['attempt'] = $lastcheck['AttemptCount'];
    $return['attemptid'] = $lastcheck['AttemptId'];
    $mail = new sendMail();
    $mail->sendSave(json_encode($r));
    print(json_encode($return));
  }
  if($action == 'session-attend'){
    $att = new Attempt();
    $return['attempt'] = $att->record($r['sessionId'], $r['userId'], array());
    $mail = new sendMail();
    $mail->sendAttendance($r['sessionId'], $r['userId']);
    $return['AttendOnly'] = isAttendanceOnly($r['sessionId']);
    print(json_encode($return));
  }
  if($action == 'check-attend'){
    $user = new User();
    $attempts = $user->retrieve_Attempts($r['userId'], $r['sessionId']);
    $attempts['AttendOnly'] = isAttendanceOnly($r['sessionId']);
    print(json_encode($attempts));
  }*/
}

?>
