<?php
require_once('connect.php');
Class record_CPD {
  Private Function get_CPD_Feed(){
    $json = "https://wsapi.360membership.com.au/mms2018/api/oa/GetUpComingEvents/cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA";
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $json);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($curl, CURLOPT_FRESH_CONNECT, TRUE);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array("Cache-Control: no-cache, must-revalidate"));
    $jsonfile = curl_exec($curl);
    if (curl_errno($curl)) {
       print curl_error($curl);
    }
    curl_close($curl);
    return $jsonfile;
  }

  Public function record_events(){
    $CPD = new record_CPD();
    $jsonfile = $CPD->get_CPD_Feed();
    $jsonresults = json_decode($jsonfile);
    $core = Core::getInstance();
    foreach($jsonresults as $event){
    if($event->ProvideId == '101238'){
      $insertsql = $core->dbc->prepare("INSERT INTO cpd_events (EventId,StartDateTime,EndDateTime,EventName,MaxPointAwarded,MaxHourAwarded,StateName,ProvideId,ProviderName,Venue,RegistrationContactName,RegistrationContactEmail,RegistrationPhoneNumber,MemberLink,PublicLink,LearningObjectives,BranchId,MoodleCourse) VALUES (:EventId,:StartDateTime,:EndDateTime,:EventName,:MaxPointAwarded,:MaxHourAwarded,:StateName,:ProvideId,:ProviderName,:Venue,:RegistrationContactName,:RegistrationContactEmail,:RegistrationPhoneNumber,:MemberLink,:PublicLink,:LearningObjectives,:BranchId,:MoodleCourse) ON DUPLICATE KEY UPDATE EventId=:EventId2,StartDateTime=:StartDateTime2,EndDateTime=:EndDateTime2,EventName=:EventName2,MaxPointAwarded=:MaxPointAwarded2,MaxHourAwarded=:MaxHourAwarded2,StateName=:StateName2,ProvideId=:ProvideId2,ProviderName=:ProviderName2,Venue=:Venue2,RegistrationContactName=:RegistrationContactName2,RegistrationContactEmail=:RegistrationContactEmail2,RegistrationPhoneNumber=:RegistrationPhoneNumber2,MemberLink=:MemberLink2,PublicLink=:PublicLink2,LearningObjectives=:LearningObjectives2,BranchId=:BranchId2,MoodleCourse=:MoodleCourse2");
      $insertsql->execute(array(
        "EventId" => $event->EventId,
        "StartDateTime" => $event->StartDateTime,
        "EndDateTime" => $event->EndDateTime,
        "EventName" => $event->EventName,
        "MaxPointAwarded" => $event->MaxPointAwarded,
        "MaxHourAwarded" => $event->MaxHourAwarded,
        "StateName" => $event->StateName,
        "ProvideId" => $event->ProvideId,
        "ProviderName" => $event->ProviderName,
        "Venue" => $event->Venue,
        "RegistrationContactName" => $event->RegistrationContactName,
        "RegistrationContactEmail" => $event->RegistrationContactEmail,
        "RegistrationPhoneNumber" => $event->RegistrationPhoneNumber,
        "MemberLink" => $event->MemberLink,
        "PublicLink" => $event->PublicLink,
        "LearningObjectives" => json_encode($event->LearningObjectives),
        "BranchId" => $event->BranchId,
        "MoodleCourse" => $event->MoodleCourse,
        "EventId2" => $event->EventId,
        "StartDateTime2" => $event->StartDateTime,
        "EndDateTime2" => $event->EndDateTime,
        "EventName2" => $event->EventName,
        "MaxPointAwarded2" => $event->MaxPointAwarded,
        "MaxHourAwarded2" => $event->MaxHourAwarded,
        "StateName2" => $event->StateName,
        "ProvideId2" => $event->ProvideId,
        "ProviderName2" => $event->ProviderName,
        "Venue2" => $event->Venue,
        "RegistrationContactName2" => $event->RegistrationContactName,
        "RegistrationContactEmail2" => $event->RegistrationContactEmail,
        "RegistrationPhoneNumber2" => $event->RegistrationPhoneNumber,
        "MemberLink2" => $event->MemberLink,
        "PublicLink2" => $event->PublicLink,
        "LearningObjectives2" => json_encode($event->LearningObjectives),
        "BranchId2" => $event->BranchId,
        "MoodleCourse2" => $event->MoodleCourse,
      ));
      echo $event->EventName.' ('.$event->EventId.') Recorded.<br>';
      }
    }
  }
  Public function record_sessions(){
    $CPD = new record_CPD();
    $jsonfile = $CPD->get_CPD_Feed();
    $jsonresults = json_decode($jsonfile);
    $core= Core::getInstance();
    foreach($jsonresults as $event){
      if($event->ProvideId == '101238'){
        if($event->SessionDetails){
          foreach($event->SessionDetails as $session){

            //var_dump($session);

            $insertsql = $core->dbc->prepare("INSERT INTO cpd_sessions (ParentId,SessionId,SessionName,IsTherapeutic,IsManufacturerSupplier,IsClinical,IsInteractive,IsAlwaysAvailable,HoursForAssessment,PointsForAssessment,CpdActivityType) VALUES (:ParentId,:SessionId,:SessionName,:IsTherapeutic,:IsManufacturerSupplier,:IsClinical,:IsInteractive,:IsAlwaysAvailable,:HoursForAssessment,:PointsForAssessment,:CpdActivityType) ON DUPLICATE KEY UPDATE ParentId=:ParentId2,SessionId=:SessionId2,SessionName=:SessionName2,IsTherapeutic=:IsTherapeutic2,IsManufacturerSupplier=:IsManufacturerSupplier2,IsClinical=:IsClinical2,IsInteractive=:IsInteractive2,IsAlwaysAvailable=:IsAlwaysAvailable2,HoursForAssessment=:HoursForAssessment2,PointsForAssessment=:PointsForAssessment2,CpdActivityType=:CpdActivityType2");
            $insertsql->execute(array(
              "ParentId"	=> $event->EventId,
              "SessionId"	=> $session->SessionId,
              "SessionName"	=> $session->SessionName,
              "IsTherapeutic"	=> $session->IsTherapeutic,
              "IsManufacturerSupplier"	=> $session->IsManufacturerSupplier,
              "IsClinical"	=> $session->IsClinical,
              "IsInteractive"	=> $session->IsInteractive,
              "IsAlwaysAvailable"	=> $session->IsAlwaysAvailable,
              "PointsForAssessment"	=> $session->PointsForAssessment,
              "HoursForAssessment"	=> $session->HoursForAssessment,
              "CpdActivityType"	=> $session->CpdActivityType,
              "ParentId2"	=> $event->EventId,
              "SessionId2"	=> $session->SessionId,
              "SessionName2"	=> $session->SessionName,
              "IsTherapeutic2"	=> $session->IsTherapeutic,
              "IsManufacturerSupplier2"	=> $session->IsManufacturerSupplier,
              "IsClinical2"	=> $session->IsClinical,
              "IsInteractive2"	=> $session->IsInteractive,
              "IsAlwaysAvailable2"	=> $session->IsAlwaysAvailable,
              "HoursForAssessment2"	=> $session->HoursForAssessment,
              "PointsForAssessment2"	=> $session->PointsForAssessment,
              "CpdActivityType2"	=> $session->CpdActivityType
            ));
            echo $session->SessionName.' ('.$session->SessionId.') Recorded.<br>';
          }
        }
      }
    }
  }

  Public function record_attendees($conferenceid){
    $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegatesByConferenceId";
    $data = array(
        "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
        "ConferenceId" => $conferenceid
    );

    $payload = json_encode($data);
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen($payload))
    );


    $json = curl_exec($curl);

    if (curl_errno($curl)) {
       print curl_error($curl);
    }
    curl_close($curl);

    $results = json_decode($json, FALSE);

    $core = Core::getInstance();
    $attendeesql = $core->dbc->prepare('INSERT INTO cpd_attendees (DelegateWebId, PrefixDelegateId, MemberId, FirstName, LastName, EventId, Email) VALUES (:DelegateWebId, :PrefixDelegateId, :MemberId, :FirstName, :LastName, :EventId, :Email) ON DUPLICATE KEY UPDATE DelegateWebID=:DelegateWebId2, Email=:Email2, FirstName=:FirstName2, LastName=:LastName2');

    foreach($results as $result){

      $attendeesql->execute(array(
        "DelegateWebId" => $result->DelegateWebID,
        "DelegateWebId2" => $result->DelegateWebID,
        "PrefixDelegateId" => $result->PrefixDelegateId,
        "MemberId" => $result->MemberId,
        "FirstName"  => $result->FirstName,
        "LastName"  => $result->Surname,
        "FirstName2"  => $result->FirstName,
        "LastName2"  => $result->Surname,
        "EventId" => $conferenceid,
        "Email" =>  $result->Email,
        "Email2" =>  $result->Email
      ));
      echo $result->TitleName.' '.$result->FirstName.' '.$result->Surname.' - '.$result->PrefixDelegateId.$result->DelegateWebID.'<br>';
    }
  }

  Public function record_attendeeSessions($webid){
      $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegateByDelegateWebId";
      $data = array(
                  "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                  "DelegateWebId" => $webid
                );
                $payload = json_encode($data);
                $curl = curl_init($url);
                curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLINFO_HEADER_OUT, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

                curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($payload))
                );

                $pre = curl_exec($curl);
                $pre = json_decode($pre, TRUE);
                $sessionjson = array();
                $i = 0;
                if($pre){
                foreach($pre['SessionsIncluded'] as $rec){
                    array_push($sessionjson, $rec['SessionId']);
                  }
                }
                $core = Core::getInstance();
                $attendeesql = $core->dbc->prepare('UPDATE cpd_attendees SET AvailableSessions = :AvailableSessions WHERE DelegateWebID = :DelegateWebID');
                $attendeesql->execute(array(
                  "DelegateWebID" => $webid,
                  "AvailableSessions" => json_encode($sessionjson)
                ));
                echo "[".$webid."] "."<strong>".$pre['PrefixDelegateId'].$pre['DelegateWebID']." - ".$pre['FirstName']." ".$pre['Surname'].":</strong> ".implode(", ", $sessionjson)."<br><hr>";
  }
}
Class display_Events {

  Public function list_sessionQuestions($sessionid){
    $sessioncpd = new retrieve_CPD();
    $session = $sessioncpd->construct_prefillArray($sessionid);
    $questions = "";
    foreach($session->questions as $question){
          $answershtml = "";
      foreach($question->answers as $answer){
          $answershtml .= '<div class="answer row col s12">' .
                              '<label>' .
                                '<input class="radio" id="question-'.$question->QuestionNumber.'-answer-'.$answer->AnswerNumber.'" name="question['.$question->QuestionNumber.'][answer]" type="radio" value="'.$answer->AnswerNumber.'"/>' .
                                '<span>' . $answer->Answer . '</span>' .
                              '</label>' .
                          '</div>';
      }
      $questions .= '<li class="question row">' .
                        '<div class="question-text row col s12"><h6>' . $question->Question . '</h6></div>' .
                        '<input type="hidden" name="question[' . $question->QuestionNumber . '][id]" value="' . $question->QuestionId . '">' .
                        '<input type="hidden" name="question[' . $question->QuestionNumber . '][order]" value="' . $question->QuestionNumber . '">' .
                        '<div id="answers row col s12">' . $answershtml . '</div>' .
                    '</li>';
    }
    return $questions;
  }

  Public function get_sessionQuestions($sessionid){
    $sessioncpd = new retrieve_CPD();
    $session = $sessioncpd->construct_prefillArray($sessionid);
    return $session;
  }

      Public function get_thumbnail($id){
        if(isset($id) && !empty($id)){
            $core=Core::getInstance();
            $thumbnailsql = $core->dbc->prepare("SELECT FileName FROM cpd_images WHERE AttachmentId=:AttachmentId");
            $thumbnailsql->execute(array(
                "AttachmentId"  =>  $id
            ));
            $thumbnail = $thumbnailsql->fetch(PDO::FETCH_ASSOC);
            $return = '<img class="event-thumbnail" src="/inc/uploads/'.$thumbnail["FileName"].'" />';
            return $return;
        } else {
            return '';
        }
    }

    Public function get_questionAnswerTotal($answerid, $questionid){
      $core = Core::getInstance();
      $pollsql = $core->dbc->prepare("SELECT COUNT(Id) as 'TOTAL' FROM cpd_polling WHERE QuestionId=:QuestionId AND AnswerId=:AnswerId");
      $pollsql->execute(array(
        'QuestionId' => $questionid,
        'AnswerId'  => $answerid
      ));
      $print = $pollsql->fetch();
      return $print['TOTAL'];
    }

    Public function check_attendance_due($sessionid = NULL, $webid = NULL, $memberid = NULL){
        $core = Core::getInstance();
        $sessiondatechecksql = $core->dbc->prepare('SELECT SessionId, SessionDate FROM cpd_sessions WHERE SessionId=:sessionid');
        $sessiondatechecksql->execute(array("sessionid"=>$sessionid));
        $sessiondate = $sessiondatechecksql->fetch(PDO::FETCH_ASSOC);
        $date1 = new DateTime(date('Y-m-d', strtotime(str_replace('/', '-', $sessiondate['SessionDate']))));
        $date2 = new DateTime(date('Y-m-d'));
        $interval = $date1->diff($date2);
        $days = $interval->days;
        if($days > 1){
        if($memberid){
        $attendchecksql = $core->dbc->prepare('SELECT cpd_attempts.UserId, cpd_attempts.AttemptInfo, cpd_sessions.SessionId FROM ((cpd_attempts INNER JOIN cpd_attendees ON cpd_attempts.UserId = cpd_attendees.DelegateWebId) INNER JOIN cpd_sessions ON cpd_attempts.ParentId=cpd_sessions.SessionId) WHERE cpd_sessions.SessionId=:sessionid AND cpd_attendees.MemberId=:memberid');
        $attendchecksql->execute(array("sessionid"=>$sessionid, "memberid"=>$memberid));
        $attendcheck = $attendchecksql->fetch(PDO::FETCH_ASSOC);
        if($attendcheck){ return TRUE; } else { return FALSE; }
        }
        if($webid){
        $attendchecksql = $core->dbc->prepare('SELECT cpd_attempts.UserId, cpd_attempts.AttemptInfo, cpd_sessions.SessionId FROM ((cpd_attempts INNER JOIN cpd_attendees ON cpd_attempts.UserId = cpd_attendees.DelegateWebId) INNER JOIN cpd_sessions ON cpd_attempts.ParentId=cpd_sessions.SessionId) WHERE cpd_sessions.SessionId=:sessionid AND cpd_attendees.DelegateWebId=:delegatewebid');
        $attendchecksql->execute(array("sessionid"=>$sessionid, "delegatewebid"=>$webid));
        $attendcheck = $attendchecksql->fetch(PDO::FETCH_ASSOC);
        if($attendcheck){ return TRUE; } else { return FALSE; }
        }
        } else {
            return TRUE;
        }
    }

  Public function list_events(){
    $core = Core::getInstance();
    $eventsql = $core->dbc->prepare("SELECT * FROM cpd_events WHERE NOW() < DATE_ADD(EndDateTime,INTERVAL +9 MONTH)");
    $eventsql->execute();
    $events = $eventsql->fetchAll(PDO::FETCH_ASSOC);
    $eventhtml = '<div class="dashboard-container row">';
    $session = new display_Events();
    foreach($events as $event){
        $eventhtml .= '<div class="event-row">';
        $eventhtml .= '<div class="preview"></div>';
        $eventhtml .= '<div class="event-name col s8">'.$session->get_thumbnail($event["ThumbnailAttachmentID"]).'<label>Event Name:</label><p>' .$event['EventName'].'</p></div>';
        $eventhtml .= '<div class="show-session col s1"><a class="waves-effect waves-light btn light-blue lighten-2 tooltipped" data-position="right" data-tooltip="Show All Sessions"><i class="material-icons">expand_more</i></a></div>';
        if($event['override'] == 0):
        $eventhtml .= '<div class="override col s1"><a class="waves-effect waves light btn grey tooltipped" data-position="right" data-tooltip="Manual Override" data-override="0" data-event-id="'.$event['EventId'].'"><i class="material-icons">warning</i></a></div>';
        else:
        $eventhtml .= '<div class="override col s1"><a class="waves-effect waves light btn red tooltipped" data-position="right" data-tooltip="Manual Override" data-override="1" data-event-id="'.$event['EventId'].'"><i class="material-icons">warning</i></a></div>';
        endif;
        $eventhtml .= '<div class="cache-session col s1"><a href="/inc/class-attendeesessions.php?EventId='.$event['EventId'].'" class="waves-effect waves-light green lighten-1 btn tooltip" data-tooltip="Cache User Sessions"><i class="material-icons">cached</i></a></div>';
        $eventhtml .= $session->list_sessions($event['EventId']);
        $eventhtml .= '<form id="image-upload-'.$event['EventId'].'" class="image-upload" method="POST" enctype="multipart/form-data"><input type="file" name="pictures" accept="image/*"/><input type="hidden" name="EventId" value="'.$event['EventId'].'" /><input type="submit" name="submit" value="upload" /></form>';
        $eventhtml .= '</div>';
    }
    $eventhtml .= '</div>';

    return $eventhtml;
  }

  Public function list_currentEvents($webid = NULL, $memberid = NULL){
    $core = Core::getInstance();
    if(isset($memberid) && !empty($memberid)){
      $attendingsql = $core->dbc->prepare('SELECT EventId FROM cpd_attendees WHERE MemberId=:MemberId');
      $attendingsql->execute(array(
        "MemberId"  => $memberid
      ));
    } else {
      $attendingsql = $core->dbc->prepare('SELECT EventId FROM cpd_attendees WHERE DelegateWebId=:DelegateWebId');
      $attendingsql->execute(array(
        "DelegateWebId"  => $webid
      ));
    }
    $attending = $attendingsql->fetchAll(PDO::FETCH_COLUMN);
    $attend = implode(", ", $attending);
    if(!$attend){
        $attend = 0;
    }
    if(isset($_SESSION['MemberId']) && $_SESSION['MemberId'] == '302794' || isset($_SESSION['MemberId']) && $_SESSION['MemberId'] == '101371' || isset($_SESSION['MemberId']) && $_SESSION['MemberId'] == '302244'){
      $eventsql = $core->dbc->prepare("SELECT * FROM cpd_events WHERE NOW() < DATE_ADD(EndDateTime,INTERVAL +3 WEEK)"); // WHERE NOW() > StartDateTime AND NOW() < DATE_ADD(EndDateTime,INTERVAL +2 WEEK)
      $eventsql->execute();
    } else {
      $eventsql = $core->dbc->prepare("SELECT * FROM cpd_events WHERE (NOW() > StartDateTime AND NOW() < DATE_ADD(EndDateTime,INTERVAL +1 DAY) AND EventId IN(".$attend.")) AND NOT force_closed='1' OR (EventId IN(".$attend.") AND override ='1' )"); // WHERE NOW() > StartDateTime AND NOW() < DATE_ADD(EndDateTime,INTERVAL +2 WEEK)
      $eventsql->execute();
    }
    $events = $eventsql->fetchAll(PDO::FETCH_ASSOC);

    $eventhtml = '<div class="dashboard-container row" style="margin: 0;">';
    $session = new display_Events();
    foreach($events as $event){

        $eventhtml .= '<div class="event-row">';
        $eventhtml .= '<div class="event-name col s8"><label>Event Name:</label><p>' .$event['EventName'].'</p></div>';
        $eventhtml .= '<div class="show-session col s1"><a class="waves-effect waves-light btn light-blue lighten-2 tooltipped" data-position="right" data-tooltip="Show All Sessions"><i class="material-icons">expand_more</i></a></div>';
        $eventhtml .=  $session->list_userSessions($webid, $memberid, $event['EventId']);
        $eventhtml .= '</div>';
    }
    if(!$events){
        $eventhtml .= '<div class="col m10 s12">
                          <div class="card horizontal">
                            <div class="card-image">
                              <img src="/img/oqldnt.jpg">
                            </div>
                            <div class="card-stacked">
                              <div class="card-content">
                                <p>Sorry there are no events currently underway.</p><br>
                                <strong>For more information go to <br>Optometry Queensland Northern Territory</strong>
                              </div>
                                <a href="https://www.optometry.org.au/about-us/our-organisation/optometry-qld-nt/">Optometry QLD/NT</a>
                                <a href="https://qldntcpd.optometry.org.au/inc/session-logout/">Log out</a>
                              </div>
                            </div>
                          </div>
                        </div>';
    }
    $eventhtml .= '</div>';
    return $eventhtml;
  }

  Public function find_delegatewebid($memberid, $conferenceid){
    $core=Core::getInstance();
    $memsql = $core->dbc->prepare('SELECT DelegateWebID FROM cpd_attendees WHERE EventId=:EventId AND MemberId=:MemberId LIMIT 1');
    $memsql->execute(array("EventId"=>$conferenceid,"MemberId"=>$memberid));
    $member = $memsql->fetch(PDO::FETCH_ASSOC);
    return $member["DelegateWebID"];
  }

  Public function retrieve_attendeeSessionCache($webid, $conferenceid=0){
    $core=Core::getInstance();
    $confsql = $core->dbc->prepare('SELECT EventId, includeallsessions FROM cpd_events WHERE EventId=:EventId LIMIT 1');
    $confsql->execute(array("EventId"=>$conferenceid));
    $conf = $confsql->fetch(PDO::FETCH_ASSOC);
    if($conf['includeallsessions'] == 1){
        $sessql = $core->dbc->prepare('SELECT SessionId FROM cpd_sessions WHERE ParentId=:ParentId ORDER BY ASC');
        $sessql->execute(array("ParentId"=>$conferenceid));
        $sessionids = $sessql->fetchAll(PDO::FETCH_COLUMN);
        $sessions["AvailableSessions"] = json_encode($sessionids);
        return $sessions["AvailableSessions"];
    } else {
        $sessql = $core->dbc->prepare('SELECT AvailableSessions FROM cpd_attendees WHERE DelegateWebID=:DelegateWebID LIMIT 1');
        $sessql->execute(array("DelegateWebID"=>$webid));
        $sessions = $sessql->fetch(PDO::FETCH_ASSOC);
        return $sessions["AvailableSessions"];
    }
  }

    Public function retrieve_attendeeBarredSessions($webid){
        $core=Core::getInstance();
        $sessql = $core->dbc->prepare('SELECT BarredSessions FROM cpd_attendees WHERE DelegateWebID=:DelegateWebID LIMIT 1');
        $sessql->execute(array("DelegateWebID"=>$webid));
        $sessions = $sessql->fetch(PDO::FETCH_ASSOC);
        return $sessions["BarredSessions"];
    }

    Public function resort_AvailableSessions($sessions=array()){
        if(isset($sessions) && !empty($sessions)){
          $csv = implode(', ', $sessions);
          $core=Core::getInstance();
          $sessql = $core->dbc->prepare("SELECT SessionId, SessionName, SessionDate,OverrideOrder FROM cpd_sessions WHERE SessionId IN({$csv}) ORDER BY SessionDate, OverrideOrder");
          $sessql->execute();
          $sessionids = $sessql->fetchAll(PDO::FETCH_COLUMN);
          return $sessionids;  
        } else {
            return array();
        }
        
    }
    
   
  Public function list_userSessions($webid = NULL, $memberid = NULL, $conferenceid){
    $class= new display_Events();
    if(!isset($webid) && empty($webid)){
      $webid = $class->find_delegatewebid($memberid, $conferenceid);
    }
    if(isset($webid) && !empty($webid)){
      $sessions = $class->retrieve_attendeeSessionCache($webid, $conferenceid);
      $barred = $class->retrieve_attendeeBarredSessions($webid);   
    }
    if(isset($sessions) && !empty($sessions)){
      $sessionhtml = '';
      $sessions = json_decode($sessions);
      $barred = json_decode($barred) ?? array();    
      
      $sessions = $class->resort_AvailableSessions($sessions);
      //asort($sessions);
      $core = Core::getInstance();
      $sessionsql = $core->dbc->prepare("SELECT * FROM cpd_sessions WHERE SessionId = :SessionId");
      $sessionhtml .= '<div class="sessions col s12">';
      foreach($sessions as $session){
        if(!in_array($session, $barred)){
            $sessionsql->execute(array(
                "SessionId" =>  $session
            ));
            if($class->check_attendance_due($session, $webid) || $class->check_attendance_due($session, NULL, $memberid)){
            $sessioninfo = $sessionsql->fetch(PDO::FETCH_ASSOC);
            if($sessioninfo['hidden'] == 0){
              $sessionhtml .= '<div class="session-row col s12">';
                  $sessionhtml .= '<div class="session-name col s6"><label>Session Name:</label><br/>'.$sessioninfo['SessionName'].'</div>';
                  $sessionhtml .= '<div class="session-points col s2"><label>Max CPD Hours</label><br/>'.$sessioninfo['HoursForAssessment'].'</div>';
                  //$sessionhtml .= '<div class="session-type col s2"><label>CPD Activity Type</label><br/>'.$sessioninfo['CpdActivityType'].'</div>';
                  $sessionhtml .= '<div class="attend-session col s1"><a href="#attend-modal" class="waves-effect waves-light btn tooltipped grey darken-3 modal-trigger attend" data-position="right" data-sessionid="'.$session.'" data-webid="'.$webid.'" data-tooltip="Attend Session"><i class="material-icons">create</i></a></div>';
                $sessionhtml .= '</div>';
              }
            }
        }  
      }
      $sessionhtml .= '</div>';
    } else {
    if($memberid && $webid){
      $webid = NULL;
    }
    if($webid){
        $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegateByDelegateWebId";
        $data = array(
                    "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                    "DelegateWebId" => $webid
                  );
    } elseif($memberid && !isset($webid) && empty($webid)) {
      $url = "https://wsapi.360membership.com.au/mms2018/api/oa/GetDelegateByMemberId";
      $data = array(
                  "PassKey" => "cwpR7blHpiMC8Txu2EwTcLfrpAYTeffnAzgaih5zybfqoYf967N1NA",
                  "MemberId" => $memberid
                );
    }
    $payload = json_encode($data);
    $curl = curl_init($url);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $payload);

    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Content-Length: ' . strlen($payload))
    );

    $pre = curl_exec($curl);
    $pre = json_decode($pre, TRUE);
    $sessionhtml = '';
    if($memberid){
      foreach($pre as $rec){
        if($rec['ConferenceID'] == $conferenceid && empty($rec['CustomField1'])){
          $core = Core::getInstance();
          $sessionsql = $core->dbc->prepare("SELECT * FROM cpd_sessions WHERE SessionId = :SessionId");
          $sessionhtml .= '<div class="sessions col s12">';
          $sessions = array();
          foreach($rec['SessionsIncluded'] as $s){
            array_push($sessions, $s['SessionId']);
          }
          asort($sessions);
          foreach($sessions as $session){
            $sessionsql->execute(array(
                "SessionId" =>  $session
            ));
            if($class->check_attendance_due($session, NULL, $memberid)){
            $sessioninfo = $sessionsql->fetch(PDO::FETCH_ASSOC);
            if($sessioninfo['hidden'] == 0){
              $sessionhtml .= '<div class="session-row col s12">';
                  $sessionhtml .= '<div class="session-name col s6"><label>Session Name:</label><br/>'.$sessioninfo['SessionName'].'</div>';
                  $sessionhtml .= '<div class="session-points col s2"><label>Max CPD Hours</label><br/>'.$sessioninfo['HoursForAssessment'].'</div>';
                  //$sessionhtml .= '<div class="session-type col s2"><label>CPD Activity Type</label><br/>'.$sessioninfo['CpdActivityType'].'</div>';
                  $sessionhtml .= '<div class="attend-session col s1"><a href="#attend-modal" class="waves-effect waves-light btn tooltipped grey darken-3 modal-trigger attend" data-position="right" data-sessionid="'.$session.'" data-webid="'.$rec['DelegateWebID'].'" data-tooltip="Attend Session"><i class="material-icons">create</i></a></div>';
                $sessionhtml .= '</div>';
              }
            }
          }
          $sessionhtml .= '</div>';
        }
      }
    }
    if($webid){
        if($pre['ConferenceID'] == $conferenceid){
          $core = Core::getInstance();
          $sessionsql = $core->dbc->prepare("SELECT * FROM cpd_sessions WHERE SessionId = :SessionId");
          $sessionhtml .= '<div class="sessions col s12">';
          $sessions = array();
          foreach($pre['SessionsIncluded'] as $s){
            array_push($sessions, $s['SessionId']);
          }
          asort($sessions);
          foreach($sessions as $session){
            $sessionsql->execute(array(
                "SessionId" =>  $session
            ));
            if($class->check_attendance_due($session, $webid)){
            $sessioninfo = $sessionsql->fetch(PDO::FETCH_ASSOC);
            if($sessioninfo['hidden'] == 0){
              $sessionhtml .= '<div class="session-row col s12">';
                  $sessionhtml .= '<div class="session-name col s6"><label>Session Name:</label><br/>'.$sessioninfo['SessionName'].'</div>';
                  $sessionhtml .= '<div class="session-points col s2"><label>Max CPD Hours</label><br/>'.$sessioninfo['HoursForAssessment'].'</div>';
                  //$sessionhtml .= '<div class="session-type col s2"><label>CPD Activity Type</label><br/>'.$sessioninfo['CpdActivityType'].'</div>';
                  $sessionhtml .= '<div class="attend-session col s1"><a href="#attend-modal" class="waves-effect waves-light btn tooltipped grey darken-3 modal-trigger attend" data-position="right" data-sessionid="'.$session.'" data-webid="'.$pre['DelegateWebID'].'" data-tooltip="Attend Session"><i class="material-icons">create</i></a></div>';
                $sessionhtml .= '</div>';
              }
            }
          }
          $sessionhtml .= '</div>';
        }
    }

    if (curl_errno($curl)) {
       print curl_error($curl);
    }
    curl_close($curl);
  }//end if/else for AvailableSessions Cache
    return $sessionhtml;
  }

 Public function list_sessions($event_id){
    if(isset($event_id) && !empty($event_id)){
        $core = Core::getInstance();
        $sessionsql = $core->dbc->prepare("SELECT * FROM cpd_sessions WHERE ParentId = :ParentId ORDER BY OverrideOrder, SessionId");
        $sessionsql->execute(array(
            "ParentId" =>  $event_id
        ));
        $sessionhtml = '';
        while($sessions = $sessionsql->fetchAll(PDO::FETCH_ASSOC)){
        $sessionhtml .= '<div class="sessions col s12">';

        foreach($sessions as $session){
            $sessionhtml .= '<div class="session-row col s12">';
                $sessionhtml .= '<div class="session-name col s5"><label>Session Name:</label><br/>'.$session['SessionName'].'</div>';
                $sessionhtml .= '<div class="session-points col s1"><label>Max CPD Hours</label><br/>'.$session['HoursForAssessment'].'</div>';
                //$sessionhtml .= '<div class="session-type col s2"><label>CPD Activity Type</label><br/>'.$session['CpdActivityType'].'</div>';
                $sessionhtml .= '<div class="update-session col s1"><a href="session-edit?e_id='.$event_id.'&s_id='.$session['SessionId'].'" class="waves-effect waves-light btn tooltipped grey darken-3" data-position="right" data-tooltip="Update Session Questionnaire"><i class="material-icons">create</i></a></div>';
                $sessionhtml .= '<div class="export-session col s1"><a href="/inc/class-export.php?sid='.$session['SessionId'].'" class="waves-effect waves-light tooltipped green lighten-1 btn" data-position="right" data-tooltip="Export Results"><i class="material-icons">file_download</i></a></div>';
                $sessionhtml .= '<div class="upload-session col s1"><a href="#cpd-upload-modal" class="cpd-upload modal-trigger waves-effect waves-light tooltipped blue lighten-1 btn" data-sessionid="'.$session['SessionId'].'" data-position="right" data-tooltip="Upload CPD"><i class="material-icons">file_upload</i></a></div>';
                if($session['hidden'] == 0):
                $sessionhtml .= '<div class="hide-session col s1"><a class="waves-effect waves light btn grey tooltipped" data-position="right" data-tooltip="Hide Session" data-hide="0" data-session-id="'.$session['SessionId'].'"><i class="material-icons">visibility_off</i></a></div>';
                else:
                $sessionhtml .= '<div class="hide-session col s1"><a class="waves-effect waves light btn red tooltipped" data-position="right" data-tooltip="Show Session" data-hide="1" data-session-id="'.$session['SessionId'].'"><i class="material-icons">visibility</i></a></div>';
                endif;
                if($session['attendance_only'] == 0):
                $sessionhtml .= '<div class="attendance-only col s1"><a class="waves-effect waves light btn grey tooltipped" data-position="right" data-tooltip="Enable Attendance Only" data-attendonly="0" data-session-id="'.$session['SessionId'].'"><i class="material-icons">pan_tool</i></a></div>';
                else:
                $sessionhtml .= '<div class="attendance-only col s1"><a class="waves-effect waves light btn red tooltipped" data-position="right" data-tooltip="Disable Attendance Only" data-attendonly="1" data-session-id="'.$session['SessionId'].'"><i class="material-icons">pan_tool</i></a></div>';
                endif;
                $sessionhtml .= '<div class="session-logs col s1"><a href="attempts-report.php?sid='.$session['SessionId'].'" class="waves-effect waves-light btn tooltipped grey darken-3" data-position="right" data-tooltip="View Session Attempt Log"><i class="material-icons">format_list_numbered</i></a></div>';
            $sessionhtml .= '</div>';
        }

        $sessionhtml .= '</div>';
        }
        return $sessionhtml;

      } else {
          $sessionhtml ="";
          return $sessionhtml;
      }
  }
}
Class retrieve_Attendee {
  Public function retrieve_Attendee_Details($userid){
      $core = Core::getInstance();
      $attendeesql = $core->dbc->prepare("SELECT * FROM cpd_attendees WHERE DelegateWebId=:userid LIMIT 1");
      $attendeesql->execute(array(
        "userid" => $userid
      ));
      $attendee = $attendeesql->fetch(PDO::FETCH_ASSOC);
      return $attendee;
  }
}

Class retrieve_CPD {
  Public function retrieve_event($id){
    $core = Core::getInstance();
    $eventsql = $core->dbc->prepare("SELECT * FROM cpd_events WHERE EventId = :EventId");
    $eventsql->execute(array(
        "EventId" =>  $id
    ));
    $event = $eventsql->fetch(PDO::FETCH_ASSOC);
    return $event;
  }

  Public function retrieve_session($id){
    $core = Core::getInstance();
    $sessionsql = $core->dbc->prepare("SELECT * FROM cpd_sessions WHERE SessionId = :SessionId");
    $sessionsql->execute(array(
        "SessionId" =>  $id
    ));
    $session = $sessionsql->fetch(PDO::FETCH_ASSOC);
    return json_decode(json_encode($session), FALSE);
  }

  Public function retrieve_questions($sid){
    $core = Core::getInstance();
    $questionssql = $core->dbc->prepare("SELECT * FROM cpd_questions WHERE ParentId = :ParentId ORDER BY QuestionNumber ASC");
    $questionssql->execute(array(
        "ParentId" =>  $sid
    ));
    $questions = $questionssql->fetchAll(PDO::FETCH_ASSOC);
    return json_decode(json_encode($questions), FALSE);
  }

  Public function retrieve_answers($qid){
    $core = Core::getInstance();
    $answerssql = $core->dbc->prepare("SELECT * FROM cpd_answers WHERE ParentId = :ParentId ORDER BY AnswerNumber ASC");
    $answerssql->execute(array(
        "ParentId" =>  $qid
    ));
    $answers = $answerssql->fetchAll(PDO::FETCH_ASSOC);
    return json_decode(json_encode($answers), FALSE);
  }

  Public function construct_prefillArray($sid){
    $CPD = new retrieve_CPD();
    $session = $CPD->retrieve_session($sid);
    $session->questions = $CPD->retrieve_questions($sid);
    $questions = array();
    foreach($session->questions as $question){
      $questions[$question->QuestionNumber] = $question;
      $answers = $CPD->retrieve_answers($question->QuestionId);
      if(isset($answers) && !empty($answers)){
        foreach($answers as $answer){
          $questions[$question->QuestionNumber]->answers[$answer->AnswerNumber] = $answer;
        }
      } else {
        $questions[$question->QuestionNumber]->answers = "";
      }
    }
    $questions = json_decode(json_encode($questions), FALSE);
    $session->questions = $questions;

    return json_decode(json_encode($session), FALSE);
  }
}


 ?>
