<?php
require_once('connect.php');
require_once('class-events.php');
require('PHPMailer/src/Exception.php');
require('PHPMailer/src/PHPMailer.php');
require('PHPMailer/src/SMTP.php');

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

Class sendMail {
  private $host = 'hosting.fusoniq.com.au';
  private $hostuser = 'noreply@qldntcpd.optometry.org.au';
  private $hostpass = 'BUnM5NxNlZ-?';

  function sendAttempt($attemptarray, $evaluation, $admin=0){
    // Instantiation and passing `true` enables exceptions
    $core = Core::getInstance();
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8';
    $evaluation = json_decode($evaluation);
    $wrong = array();
    if($evaluation->w):
      foreach($evaluation->w as $w){
        array_push($wrong, $w->n);
      }
    endif;
    $correct = array();
    if($evaluation->c):
      foreach($evaluation->c as $c){
        array_push($correct, $c->n);
      }
    endif;
    $attempt = json_decode($attemptarray);
    $sid = $attempt->session->sessionId;
    $ret_sess = new retrieve_CPD();
    $session = $ret_sess->retrieve_session($sid);
    $usersql = $core->dbc->prepare("SELECT CONCAT(FirstName, ' ', LastName) as 'MemberName', MemberId, Email FROM cpd_attendees WHERE DelegateWebId LIKE :id");
    $usersql->execute(array(
      "id"  => $attempt->user->userId
    ));
    $user = $usersql->fetch(PDO::FETCH_ASSOC);
    $sessresults .= '<ul>';
    $questions = $attempt->question;
    foreach($questions as $question){
      $qsql = $core->dbc->prepare("SELECT Question FROM cpd_questions WHERE QuestionId LIKE :QuestionId");
      $qsql->execute(array(
        "QuestionId" => $question->id
      ));
      $qmsg = $qsql->fetch(PDO::FETCH_ASSOC);
      $sessresults .= '<li>';
      $sessresults .= '<strong>'.$qmsg['Question'].'</strong><br>';
      $asql = $core->dbc->prepare("SELECT Answer FROM cpd_answers WHERE ParentId LIKE :QuestionId AND AnswerNumber LIKE :AnswerNumber");
      $asql->execute(array(
        "QuestionId" => $question->id,
        "AnswerNumber" => $question->answer
      ));
    $messageptone ='';
    $messagepttwo ='';
    if($evaluation->html == 'Attempt Successful'){
        $messageptone ='You have successfully completed the assessment for';
        $messagepttwo ='Your results are as follows:';
    } else {
        $messageptone ='Your assessment attempt for';
        $messagepttwo ='was unfortunately unsuccessful as you did not reach the 50% pass mark. Please log in to EliteCPD to try again at qldntcpd.optometry.org.au. <br>Below are the questions and your attempted answers:';
    }

      $amsg = $asql->fetch(PDO::FETCH_ASSOC);
      $sessresults .= $amsg['Answer'];
      if(in_array($question->order, $wrong)){
        $sessresults .= '- <strong>INCORRECT</strong><br><br>';
      } elseif(in_array($question->order, $correct)) {
        $sessresults .= '- <strong>CORRECT</strong><br><br>';
      }
      $sessresults .= '</li>';
    }
    $sessresults .= '</ul>';
    $msg = file_get_contents('email-templates/evaluation.html');
    $msg = str_replace("{{MEMBERNAME}}", $user['MemberName'], $msg);
    $msg = str_replace("{{MEMBERID}}", $user['MemberId'], $msg);
    $msg = str_replace("{{MESSAGE_PART_ONE}}",$messageptone, $msg);
    $msg = str_replace("{{MESSAGE_PART_TWO}}",$messagepttwo, $msg);
    $msg = str_replace("{{SESSIONNAME}}", $session->SessionName, $msg);
    $msg = str_replace("{{SESSIONRESULTS}}", $sessresults, $msg);
    try {
        //Server settings
        $mail->SMTPDebug = 0;                                       // Enable verbose debug output
        $mail->isSMTP();                                            // Set mailer to use SMTP
        $mail->Host       = $this->host;  // Specify main and backup SMTP servers
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = $this->hostuser;                     // SMTP username
        $mail->Password   = $this->hostpass;                               // SMTP password
        //$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;                                  // Enable TLS encryption, `ssl` also accepted
        $mail->Port       = 25;                                    // TCP port to connect to

        $email = "noreply@qldntcpd.optometry.org.au";

        //Recipients
        $mail->setFrom($email, 'EliteCPD - CPD Assessment');
        $mail->addAddress($user['Email']);     // Add a recipient
        //$mail->addAddress('ruben@fusoniq.com.au');
        $mail->addAddress('l.busuttil@optometry.org.au');
        // Content
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = 'EliteCPD - ' . $evaluation->html . ' - ' . $session->SessionName;
        $mail->AddEmbeddedImage("../img/elitecpd.png", "elitecpd");
        $mail->Body = $msg;

        $mail->send();
        //echo 'Message has been sent';
    } catch (Exception $e) {
        //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
  }

  function sendSave($attemptarray, $admin=0){
    // Instantiation and passing `true` enables exceptions
    $core = Core::getInstance();
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8';
    $attempt = json_decode($attemptarray);
    $sid = $attempt->session->sessionId;
    $ret_sess = new retrieve_CPD();
    $session = $ret_sess->retrieve_session($sid);
    $usersql = $core->dbc->prepare("SELECT CONCAT(FirstName, ' ', LastName) as 'MemberName', MemberId, Email FROM cpd_attendees WHERE DelegateWebId LIKE :id");
    $usersql->execute(array(
      "id"  => $attempt->user->userId
    ));
    $user = $usersql->fetch(PDO::FETCH_ASSOC);
    $sessresults .= '<ul>';
    $questions = $attempt->question;
    foreach($questions as $question){
      $qsql = $core->dbc->prepare("SELECT Question FROM cpd_questions WHERE QuestionId LIKE :QuestionId");
      $qsql->execute(array(
        "QuestionId" => $question->id
      ));
      $qmsg = $qsql->fetch(PDO::FETCH_ASSOC);
      $sessresults .= '<li>';
      $sessresults .= '<strong>'.$qmsg['Question'].'</strong><br>';
      $asql = $core->dbc->prepare("SELECT Answer FROM cpd_answers WHERE ParentId LIKE :QuestionId AND AnswerNumber LIKE :AnswerNumber");
      $asql->execute(array(
        "QuestionId" => $question->id,
        "AnswerNumber" => $question->answer
      ));
      $amsg = $asql->fetch(PDO::FETCH_ASSOC);
      $sessresults .= $amsg['Answer'];
      $sessresults .= '</li>';
    }
    $sessresults .= '</ul>';
    $msg = file_get_contents('email-templates/saved-progress.html');
    $msg = str_replace("{{MEMBERNAME}}", $user['MemberName'], $msg);
    $msg = str_replace("{{MEMBERID}}", $user['MemberId'], $msg);
    $msg = str_replace("{{SESSIONNAME}}", $session->SessionName, $msg);
    $msg = str_replace("{{SESSIONRESULTS}}", $sessresults, $msg);
    try {
        //Server settings
        $mail->SMTPDebug = 0;                                       // Enable verbose debug output
        $mail->isSMTP();                                            // Set mailer to use SMTP
        $mail->Host       = $this->host;  // Specify main and backup SMTP servers
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = $this->hostuser;                     // SMTP username
        $mail->Password   = $this->hostpass;                               // SMTP password
        //$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;                                  // Enable TLS encryption, `ssl` also accepted
        $mail->Port       = 25;                                    // TCP port to connect to

        $email = "noreply@qldntcpd.optometry.org.au";

        //Recipients
        $mail->setFrom($email, 'EliteCPD - CPD Assessment');
        $mail->addAddress($user['Email']);     // Add a recipient
        //$mail->addAddress('ruben@fusoniq.com.au');
        $mail->addAddress('l.busuttil@optometry.org.au');
        // Content
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = 'EliteCPD - Progress Saved - ' . $session->SessionName;
        $mail->AddEmbeddedImage("../img/elitecpd.png", "elitecpd");
        $mail->Body = $msg;

        $mail->send();
        //echo 'Message has been sent';
    } catch (Exception $e) {
        //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
  }

  function sendAttendance($sessionid, $userid, $admin=0){
    $core = Core::getInstance();
    $mail = new PHPMailer(true);
    $mail->CharSet = 'UTF-8';
    $sid = $sessionid;
    //var_dump($userid);
    $ret_sess = new retrieve_CPD();
    $session = $ret_sess->retrieve_session($sid);
    $usersql = $core->dbc->prepare("SELECT CONCAT(FirstName, ' ', LastName) as 'MemberName', MemberId, Email FROM cpd_attendees WHERE DelegateWebId LIKE :id");
    $usersql->execute(array(
      "id"  => $userid
    ));
    $user = $usersql->fetch(PDO::FETCH_ASSOC);
    $msg = file_get_contents('email-templates/attendance.html');
    $msg = str_replace("{{MEMBERNAME}}", $user['MemberName'], $msg);
    $msg = str_replace("{{MEMBERID}}", $user['MemberId'], $msg);
    $msg = str_replace("{{SESSIONNAME}}", $session->SessionName, $msg);
    try {
        //Server settings
        //Server settings
        $mail->SMTPDebug = 0;                                       // Enable verbose debug output
        $mail->isSMTP();                                            // Set mailer to use SMTP
        $mail->Host       = $this->host;  // Specify main and backup SMTP servers
        $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
        $mail->Username   = $this->hostuser;                     // SMTP username
        $mail->Password   = $this->hostpass;                               // SMTP password
        //$mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;                                  // Enable TLS encryption, `ssl` also accepted
        $mail->Port       = 25;                                    // TCP port to connect to                                 // TCP port to connect to

        $email = "noreply@qldntcpd.optometry.org.au";

        //Recipients
        $mail->setFrom($email, 'EliteCPD - CPD Assessment');
        //var_dump($user['Email']);
        $mail->addAddress($user['Email']);     // Add a recipient
        //$mail->addAddress('ruben@fusoniq.com.au');
        $mail->addAddress('l.busuttil@optometry.org.au');
        // Content
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = 'EliteCPD-Attendance Confirmed- ' . $session->SessionName .' - '. $user['MemberId'];
        $mail->AddEmbeddedImage("../img/elitecpd.png", "elitecpd");
        $mail->Body = $msg;

        $mail->send();
        //echo 'Message has been sent';
    } catch (Exception $e) {
        //echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }
  }
}
?>
