<?php
require_once('class-ajax.php');
session_start(); // Starting Session
session_regenerate_id();
if(isset($_POST['webid']) && !empty($_POST['webid'])){
  $_user = htmlspecialchars($_POST['webid'], ENT_QUOTES);
  $core = core::getInstance();
  $loginchecksql = $core->dbc->prepare("SELECT * FROM cpd_attendees WHERE CONCAT(PrefixDelegateId, DelegateWebId) LIKE :DelegateWebId");
  $loginchecksql->execute(array(
    "DelegateWebId" => $_user
  ));
  $logincheck = $loginchecksql->fetch(PDO::FETCH_ASSOC);
	if ($logincheck){
      $_SESSION['login_user'] = $_user; // Initializing Session
      header("location: https://qldntcpd.optometry.org.au/"); // Redirecting To Other Page
	    echo "You have successfully logged in.";
      exit();
	} else {
      header("location: https://qldntcpd.optometry.org.au/login/?msg=1");
	    echo "Invalid Username/Password";
      exit();
	}
}
if(isset($_POST['adminid']) && !empty($_POST['adminid'])){
  $core = core::getInstance();
  $adminsql = $core->dbc->prepare('SELECT * FROM cpd_admin WHERE adminid=:adminid');
  $adminsql->execute(array(
    "adminid" => htmlspecialchars($_POST['adminid']),
  ));
  $admin = $adminsql->fetch(PDO::FETCH_ASSOC);
  if(password_verify($_POST['password'], $admin['password'])){
    $_SESSION['login_user'] = $_POST['adminid'];
    $_SESSION['isadmin'] = "TRUE";
    header("location: https://qldntcpd.optometry.org.au/"); // Redirecting To Other Page
    echo "You have successfully logged in.";
    exit();
  } else {
    var_dump(password_verify($_POST['password'], $admin['password']));
    echo "Invalid Username/Password";
    exit();
  }
}

?>
